<?php
session_start();
require_once "../../../controladores/caja.controlador.php";
require_once "../../../modelos/caja.modelo.php";

require_once "../../../controladores/plantilla.controlador.php";
require_once "../../../modelos/configuracion.modelo.php";


// require_once "../../../controladores/productos.controlador.php";
// require_once "../../../modelos/productos.modelo.php";

class imprimirEstadoServicio{

public $idUsuario;

public function traerImpresionEstadoServicio(){

	date_default_timezone_set("America/Mexico_City");
    setlocale(LC_ALL, 'spanish');

//TRAEMOS LA INFORMACIÓN DE LA VENTA
$plantilla = new ControladorPlantilla();
$configuracion = $plantilla -> ctrConfiguracion()[0];
$logo = $configuracion['logo'];
$razon_social = $configuracion['razon_social'];
$prefijo =  $configuracion['prefijo'];
$celular =  $configuracion['celular'];
$email =  $configuracion['email'];
$direccion =  $configuracion['direccion'];
$nombreEmpresa = "$razon_social <br>Celular: $prefijo $celular <br> Correo: $email <br> Dirección: $direccion";

$idusuario = $this->idUsuario;
$fecha1 = null;
$fecha2 = null;
if(isset($_GET['fecha1']))
	$fecha1 = $_GET['fecha1'];
if(isset($_GET['fecha2']))
	$fecha2 = $_GET['fecha2'];

$datosCaja = ControladorCaja::ctrMostrarCajas($idusuario,  null, $fecha1, $fecha2);
//REQUERIMOS LA CLASE TCPDF
if(count($datosCaja) == 0){
	echo "El usuario no presenta registros vuelva a intertarlo mas tarde o verifique que la fecha coinsida con las tablas registras";
	echo "<br>";
	echo "Fecha inicio filtro: ".$fecha1."<br>";
	echo "Fecha fin filtro: ".$fecha2;
	exit;
}

require_once('tcpdf_include.php');

$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

$pdf->startPageGroup();

$pdf->AddPage('L','JIS_B4');

// ---------------------------------------------------------

$bloque1 = <<<EOF

	<table>

		<tr>

			<td style="width:200px">
			<div>
			<br>
			<img src="../../../$logo" style="width: 140px;">
			</div>
			</td>

			<td style="background-color:white; width:760px">
				<br>
				<div style="font-size:8.5px; text-align:right; line-height:15px;">

					$nombreEmpresa

				</div>

			</td>




		</tr>



	</table>



EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');



//se modificaron las columnas

$bloque3 = <<<EOF

	<table style="font-size:9px; padding:5px 10px;">

		<tr>
		<br>
		<br>

		<td style="border: 1px solid #666666; background-color:white; width:60px; text-align:center"><b>id.</b></td>

		<td style="border: 1px solid #666666; background-color:white; width:80px; text-align:center"><b>Fecha Registro</b></td>
		<td style="border: 1px solid #666666; background-color:white; width:80px; text-align:center"><b>Fecha Cierre</b></td>

		<td style="border: 1px solid #666666; background-color:white; width:140px; text-align:center"><b>Nombres</b></td>

		<td style="border: 1px solid #666666; background-color:white; width:70px; text-align:center"><b>Apertura Caja</b></td>

		<td style="border: 1px solid #666666; background-color:white; width:70px; text-align:center"><b>Total Comercial</b></td>
		<td style="border: 1px solid #666666; background-color:white; width:80px; text-align:center"><b>Total Domiciliario</b></td>
		<td style="border: 1px solid #666666; background-color:white; width:80px; text-align:center"><b>Total ingreso</b></td>
		<td style="border: 1px solid #666666; background-color:white; width:80px; text-align:center"><b>ingreso bruto</b></td>
		<td style="border: 1px solid #666666; background-color:white; width:80px; text-align:center"><b>Total entregado</b></td>
		<td style="border: 1px solid #666666; background-color:white; width:80px; text-align:center"><b>Saldo Siguiente</b></td>
		<td style="border: 1px solid #666666; background-color:white; width:60px; text-align:center"><b>estado</b></td>

		</tr>

	</table>

EOF;

$pdf->writeHTML($bloque3, false, false, false, false, '');

// -------------------------------------------------

// Aqui  hace el ciclo para agregar las filas
$aperturaC = 0;
$totalDom = 0;
$totalCom = 0;
$totalIng = 0;
$totalEnt = 0;
$totalInB = 0;
$saldoSig = 0;

foreach ($datosCaja as $key => $value) {

//	$valor = "S/.".$value["valor_servicio"].".00";
	//$fecha = substr($value["fecha_inicio"],0,-8);


	$valor = "";
	$totalComercial = number_format($value['totalComercial'],2,'.',',');
	$totalDomiciliario = number_format($value['totalDomiciliario'],2,'.',',');
	$totalIngreso = number_format($value['totalIngreso'],2,'.',',');
	$totalEntregado = number_format($value['totalEntregado'],2,'.',',');
	$IngresoBruto = number_format(($value['totalIngreso'] + $value['AperturaCaja']),2,'.',',');

	$saldoSiguiente = number_format($value['saldoSigiente'],2,'.',',');
	$aperturaCaja = number_format($value['AperturaCaja'],2,'.',',');

	$aperturaC = $aperturaC + $value['AperturaCaja'];
	$totalDom = $totalDom + $value['totalComercial'];
	$totalCom = $totalCom + $value['totalDomiciliario'];
	$totalIng = $totalIng + $value['totalIngreso'];
	$totalEnt = $totalEnt + $value['totalEntregado'];
	$totalInB = $totalInB + $value['totalIngreso'];
	$saldoSig = $saldoSig + $value['saldoSigiente'];




$bloque4 = <<<EOF

 	<table style="font-size:10px; padding:5px 10px;">

 		<tr>
 			<td style="border: 1px solid #666666; color:#333; background-color:white; width:60px; text-align:center"><b>
 				$value[id]</b>
 			</td>

 			<td style="border: 1px solid #666666; color:#333; background-color:white; width:80px; text-align:center">
 				$value[fechaRegistro]
 			</td>

			 <td style="border: 1px solid #666666; color:#333; background-color:white; width:80px; text-align:center">
 				$value[fechaCierre]
 			</td>

 			<td style="border: 1px solid #666666; color:#333; background-color:white; width:140px; text-align:center">
 				$value[nombre]
 			</td>

 			<td style="border: 1px solid #666666; color:#333; background-color:white; width:70px; text-align:center">$aperturaCaja
 			</td>

 			<td style="border: 1px solid #666666; color:#333; background-color:white; width:70px; text-align:center">
			 $totalComercial
 			</td>
 			<td style="border: 1px solid #666666; color:#333; background-color:white; width:80px; text-align:center">
			 $totalDomiciliario
 			</td>

 			<td style="border: 1px solid #666666; color:#333; background-color:white; width:80px; text-align:center">$totalIngreso
 			</td>
			 <td style="border: 1px solid #666666; color:#333; background-color:white; width:80px; text-align:center">$IngresoBruto
 			</td>
 			<td style="border: 1px solid #666666; color:#333; background-color:white; width:80px; text-align:center">$totalEntregado
 			</td>
 			<td style="border: 1px solid #666666; color:#333; background-color:white; width:80px; text-align:center">$saldoSiguiente
 			</td>
 			<td style="border: 1px solid #666666; color:#333; background-color:white; width:60px; text-align:center">$value[estadoCierre]
 			</td>



 		</tr>

 	</table>


EOF;

	$pdf->writeHTML($bloque4, false, false, false, false, '');

}


$aperturaC = number_format($aperturaC,2,'.',',');
$totalDom = number_format($totalDom,2,'.',',');
$totalCom = number_format($totalCom,2,'.',',');
$totalIng = number_format($totalIng,2,'.',',');
$totalEnt = number_format($totalEnt,2,'.',',');
$totalInB = number_format($totalInB,2,'.',',');
$saldoSig = number_format($saldoSig,2,'.',',');

//total
$bloque5 = <<<EOF

 	<table style="font-size:10px; padding:5px 10px;">

 		<tr>
 			<td style="border: 1px solid #666666; color:#333; background-color:white; width:360px; text-align:right"><b>
 				Total:</b>
 			</td>
			<td style="border: 1px solid #666666; color:#333; background-color:white; width:70px; text-align:center">$aperturaC
 			</td>

 			<td style="border: 1px solid #666666; color:#333; background-color:white; width:70px; text-align:center">
			 $totalCom
 			</td>
 			<td style="border: 1px solid #666666; color:#333; background-color:white; width:80px; text-align:center">
			$totalDom
 			</td>

 			<td style="border: 1px solid #666666; color:#333; background-color:white; width:80px; text-align:center">$totalIngreso
 			</td>
			 <td style="border: 1px solid #666666; color:#333; background-color:white; width:80px; text-align:center">$totalInB
 			</td>
 			<td style="border: 1px solid #666666; color:#333; background-color:white; width:80px; text-align:center">$totalEnt
 			</td>
 			<td style="border: 1px solid #666666; color:#333; background-color:white; width:80px; text-align:center">$saldoSig
 			</td>
 			<td style="border: 1px solid #666666; color:#333; background-color:white; width:60px; text-align:center">$value[estadoCierre]
 			</td>



 		</tr>

 	</table>


EOF;

	$pdf->writeHTML($bloque5, false, false, false, false, '');



//SALIDA DEL ARCHIVO

//$pdf->Output('factura.pdf', 'D');
$pdf->Output('Estado_Cuenta.pdf');

}

}

$reporte = new imprimirEstadoServicio();
$reporte -> idUsuario = base64_decode($_GET["idcaja"]);
//echo base64_decode($_GET["idcaja"]);
$reporte -> traerImpresionEstadoServicio();

?>
